<?php
/*
Template Name: Temoins
MultiEdit:x,y,ouverture,adresse,contact
*/
?>

<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post();?>

<?php get_sidebar(); ?>
            
<script>
	$(document).ready(function(){
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$('#formulaire_perso input').each(function(){
			$(this).attr('src', $(this).attr('value'));
		});
		$('#formulaire_perso textarea').each(function(){
			$(this).attr('src', $(this).html());
		});
		
		$('#groupe_temoins').addClass('selected');
		
		$('#content_temoins #temoins #encart_droite>div ul li').click(function(){
			$('#content_temoins #temoins #encart_droite>div ul li').removeClass('selected');
			$(this).addClass('selected');
			$('.bas_temoins').removeClass('selected');
			$($(this).attr('rel')).addClass('selected');
			var rel = $(this).attr('rel');
			$('#carte>img').each(function(){
				if ($(this).attr('rel') != rel){
					$(this).attr('src', $(this).attr('src').replace('temoin_selected.', 'temoin.'));
					$(this).attr('src', $(this).attr('src').replace('temoin_sans_selected.', 'temoin_sans.'));
				}
				else {
					$(this).attr('src', $(this).attr('src').replace('temoin.', 'temoin_selected.'));
					$(this).attr('src', $(this).attr('src').replace('temoin_sans.', 'temoin_sans_selected.'));
					
				}
			});
			
		});
		
		$('#temoins_0').addClass('selected');
		$('#carte>img').each(function(){
			if ($(this).attr('rel') == '#temoins_0'){
				$(this).attr('src', $(this).attr('src').replace('temoin.', 'temoin_selected.'));
				$(this).attr('src', $(this).attr('src').replace('temoin_sans.', 'temoin_sans_selected.'));
			}
		});
		
		$('.bas_temoins').each(function(){
			$(this).find('.gallery-item').first().addClass('selected');
			$(this).find('.grande_temoin').attr('src', $(this).find('.gallery-item').first().find('a').attr('href'));
		});
		
		
		$('.gallery-item').click(function(){
			$(this).parent().find('.gallery-item').removeClass('selected');
			$(this).addClass('selected');
			console.log($(this).find('a').attr('href'));
			$(this).closest('.bas_temoins').find('.grande_temoin').attr('src', $(this).find('a').attr('href'));
			return false;
		});
		
		$('.formulaire_perso').each(function(){
			// $('#temoin_hidden').attr('value', "<?php echo get_the_title(). ' offre '.get_the_ID(); ?>");
			$(this).find('.temoin_hidden').attr('value', $(this).find(".nom_form").html()+" - id: "+$(this).find(".id_form").html());
			$(this).find('.contenu_temoin').html($(this).closest('.bas_temoins').find('.type_form').html()+" - "+$(this).find(".nom_form").html());
		});
		
		
	});
</script>

<?php include('menu_groupe.php'); ?>



<?php
	if (get_locale()=='fr_FR') {
		$maisons_id = 906;
		$appartements_id = 912;
	}
	else if (get_locale()=='en_US') {
		$maisons_id = 911;
		$appartements_id = 915;
	}
	else if (get_locale()=='de_DE') {
		$maisons_id = 909;
		$appartements_id = 914;
	}
	$maisons = get_children($maisons_id); 
	$appartements = get_children($appartements_id); 
	$cpt = 0;
?>

<div id="container_content" class="page_groupe">
    <div class="content" id="content_temoins">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP GROUP', 'piron'); ?> > <span class="current"><?php echo get_the_title(); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>

		<div id="temoins">
        	<h1><?php echo strtoupper(get_the_title()); ?></h1>
            
            <div id="desc_temoins">
            	<?php _e('Visitez une maison t&eacute;moin ou un appartement t&eacute;moin Thomas et Piron. Nos maisons et appartements t&eacute;moins sont d\'excellentes sources d\'inspiration et vous fournissent souvent de bonnes id&eacute;es pour l’am&eacute;nagement de votre maison. <br/><br/>Elles vous montreront le savoir-faire et les qualit&eacute;s dont nous faisons preuve dans la contruction et les finitons haut de gamme que nous aimons proposer &agrave; nos clients et ainsi vous conforteront dans votre d&eacute;sir de nous confier votre projet.', 'piron'); ?>
            </div>
            
            <div id="carte">
            	<div>
            		<img src="<?php echo get_template_directory_uri(); ?>/img/carte_temoins_2.png" alt="carte" />
                </div>
				<?php $cpt_min = 0;
				foreach ($maisons as $maison) { ?>
					
					<img src="<?php echo get_template_directory_uri(); ?>/img/maison_temoin<?php if (strtolower(get_the_title($maison->ID))=='kirchberg') echo '_sans';?>.png" rel="#temoins_<?php echo $cpt_min; ?>" style="left:
					<?php $value = get_post_meta($maison->ID, 'multiedit_x', true); echo strip_tags($value, '<br>'); ?>px; top:
					<?php $value = get_post_meta($maison->ID, 'multiedit_y', true); echo strip_tags($value, '<br>'); ?>px;"/>
				<?php $cpt_min++;
				} 
				
				foreach ($appartements as $appartement) { ?>
					
					<img src="<?php echo get_template_directory_uri(); ?>/img/immeuble_temoin.png" rel="#temoins_<?php echo $cpt_min; ?>" style="left:
					<?php $value = get_post_meta($appartement->ID, 'multiedit_x', true); echo strip_tags($value, '<br>'); ?>px; top:
					<?php $value = get_post_meta($appartement->ID, 'multiedit_y', true); echo strip_tags($value, '<br>'); ?>px;"/>
				<?php $cpt_min++;
				} ?>
                
            </div>
            
            <div id="encart_droite">
            	<div id="maisons">
                	<b><?php echo strtoupper(get_the_title($maisons_id)); ?></b>
                    <ul>
						
						<?php foreach ($maisons as $maison) {
							echo '<li ';
							if ($cpt==0) echo 'class="selected" ';
							echo 'rel="#temoins_'.$cpt.'">'.strtoupper(get_the_title($maison)).'</li>';
							$cpt++;
						} ?>
                    	
                    </ul>
                    <img src="<?php echo get_template_directory_uri(); ?>/img/maison_temoin.png" alt="" />
                </div>
                
                <div id="appartements">
                	<b><?php echo strtoupper(get_the_title($appartements_id)); ?></b>
                    <ul>
						<?php foreach ($appartements as $appartement) {
							echo '<li rel="#temoins_'.$cpt.'">'.strtoupper(get_the_title($appartement)).'</li>';
							$cpt++;
						} ?>
                    </ul>
                    <img src="<?php echo get_template_directory_uri(); ?>/img/immeuble_temoin.png" alt="" />
                </div>
            </div>
         </div>
		 
		 
		 <?php $all_temoins = array_merge($maisons, $appartements); 
		 $cpt_all = 0;
		 foreach ($all_temoins as $temoin) { ?>

		<div class="bas_temoins" id="temoins_<?php echo $cpt_all; ?>">
        	<div id="bandeau">
				
            	<?php echo get_the_title($temoin); ?><br/>
				<span class="type_form">
				<?php if ($temoin->post_parent == 906 || $temoin->post_parent == 911 || $temoin->post_parent == 909) {
					_e('Maison t&eacute;moin', 'piron');
				} 
				else {
					echo _e('Appartement t&eacute;moin', 'piron');
				}?>
				</span>
                
            </div>
            <img src="<?php echo get_template_directory_uri(); ?>/img/grande_temoins.png" alt="" class="grande_temoin"/>
            <div class="droite_temoins">
            	<div class="liste_thumbs">
                	<?php $my_postid = $temoin->ID;
					$content_post = get_post($my_postid);
					$content = $content_post->post_content;
					$content = apply_filters('the_content', $content);
					$content = str_replace(']]>', ']]&gt;', $content);
					echo $content; ?>
                </div>
                <div class="clear"></div>
                <div class="infos_temoins">
                    <div class="infos_1">
                        <div class="chevron_rouge">&gt;</div>
                        <b>OUVERTURE :</b><br/>
                        <?php $value = get_post_meta($temoin->ID, 'multiedit_ouverture', true); echo strip_tags($value, '<br>'); ?>
                    </div>
                    <div class="infos_2">
                        <div class="chevron_rouge">&gt;</div>
                        <b>ADRESSE :</b><br/>
                        <?php $value = get_post_meta($temoin->ID, 'multiedit_adresse', true); echo strip_tags($value, '<br>'); ?>
                    </div>
                    
                </div>
                
                <div id="formulaire_perso" class="formulaire_perso">
					<span class="hidden id_form"><?php echo $temoin->ID; ?></span>
					<span class="hidden nom_form"><?php echo get_the_title($temoin); ?></span>
                    <?php $value = get_post_meta($temoin->ID, 'multiedit_contact', true);
					$value = apply_filters('the_content', $value);
					$value = str_replace(']]>', ']]&gt;', $value);
					echo $value; ?>
                </div>
            </div>
            
        </div>
		
		<?php $cpt_all++;
		} ?>
        
        <div class="spacer"></div> 
    	
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>