<?php
/*
Template Name: References
MultiEdit:image_principale
*/
?>

<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post();?>

<?php get_sidebar(); ?>

<script>
	$(document).ready(function(){
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$('#groupe_references').addClass('selected');
		
		$('.une_reference').mouseover(function(){
			$(this).addClass('selected');
		});
		$('.une_reference').mouseout(function(){
			$(this).removeClass('selected');
		});
		
		$(".une_reference").overlay({mask:'#000', closeOnClick:true});
		
		$('.simple_overlay').each(function(){
			$(this).find('.gallery-item').first().addClass('selected');
			$(this).find('.container_grande_image').html('<img src="'+$(this).find('.gallery-item').first().find('a').attr('href')+'" alt="" />');
		});
		
		$('.simple_overlay').each(function(){
			$(this).find('.nb_current').html(1);
			$(this).find('.nb_total').html($(this).find('.gallery-item').length);
		});
		
		$('.gallery-item').click(function(){
			var item=$(this).find('a').attr('href');
			$(this).parent().find('.gallery-item').removeClass('selected');
			$(this).addClass('selected');
			$(this).parent().parent().find('.container_grande_image').html('<img src="'+$(this).find('a').attr('href')+'" alt="" />');
			var cpt=1;
			var current=0;
			$(this).parent().find('.gallery-item').each(function(){
				if ($(this).find('a').attr('href') == item){
					current = cpt;
				}
				cpt++;
			});
			$(this).parent().parent().find('.nb_current').html(current);
			$(this).parent().parent().find('.nb_total').html($(this).parent().find('.gallery-item').length);
			return false;
		});
		
	});
</script>

<?php include('menu_groupe.php'); ?>

<div id="container_content" class="page_groupe">
    <div class="content content_groupe_references" id="content_references_maisons">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP GROUP', 'piron'); ?> > <?php _e('R&eacute;f&eacute;rences', 'piron'); ?> > <span class="current"><?php echo get_the_title(); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>

		<div id="menu_references" class="menu_gauche">
			<img src="<?php echo get_template_directory_uri(); ?>/img/bg_historique.png"/>
        	<?php $children = get_children(
						array(
							'post_parent' => $post->post_parent,
							'orderby' => 'menu_order',
							'order'=>'ASC'
						)
					);?>
        	<ul>
				<?php foreach ($children as $key=>$child) { ?>
            	<li <?php if ($key==get_the_ID()) echo 'class="selected"'; ?>><a href="<?php echo get_page_link($key); ?>"><?php echo strtoupper(get_the_title($key)); ?></a></li>
				<?php } ?>
            </ul>
        </div>
        
        <div id="references">
        	<h1><?php _e('R&Eacute;F&Eacute;RENCES', 'piron'); ?> / <?php echo strtoupper(get_the_title()); ?></h1>
            
            <div id="liste_references">
            	<?php 
				$children = get_children(
						array(
							'post_parent' => get_the_ID(),
							'orderby' => 'menu_order',
							'order'=>'ASC'
						)
					);
				$cpt=0;
				foreach ($children as $key=>$child){ ?>
                    <div class="une_reference button<?php if ($cpt<4) echo ' first_line';?>" rel="#overlay_<?php echo $key;?>">
                        <?php $value = get_post_meta($key, 'multiedit_image_principale', true); echo strip_tags($value, '<br><img>'); ?><br/>
						<?php echo strtoupper(get_the_title($key)); ?>
                    </div>
                <?php $cpt++;
				} ?>
                <div class="clear"></div>
            </div>
            
          
    </div>
     <div class="spacer"></div> 
</div>

<?php $children=get_children(get_the_ID());
foreach ($children as $key=>$child){ 

$args=array(
  'page_id' => $key,
  'post_type' => 'page',
  'post_status' => 'publish',
  'posts_per_page' => 1,
  'caller_get_posts'=> 1
);
$my_query = null;
$my_query = new WP_Query($args);
if( $my_query->have_posts() ) {
  while ($my_query->have_posts()) : $my_query->the_post(); ?>
    <div class="simple_overlay" id="overlay_<?php echo get_the_ID(); ?>">
		<div class="container_grande_image"></div>
		<?php the_content(); ?>
		<div class="legende"><span class="rouge"><?php echo get_the_title(); ?></span> - <span class="nb_current"></span>/<span class="nb_total"></span></div>
	</div>
  <?php endwhile;
}
wp_reset_query();  // Restore global post data stomped by the_post().
?>

<?php } ?>

<?php endwhile; endif; ?>

<?php get_footer(); ?>