<?php
/*
Template Name: Partenaires
MultiEdit:web,adresse,usage,duree,specificites,titre_1,titre_2,titre_3,titre_4,titre_5,contenu_1,contenu_2,contenu_3,contenu_4,contenu_5,logo,images,nom_long
*/
?>

<?php get_header(); ?>
<?php get_sidebar(); ?>

<script>
	$(document).ready(function(){
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$('#groupe_partenariats').addClass('selected');
		
		var width_ul_nav = 0;
		$('#nav_detail ul>li').each(function(){
			width_ul_nav += $(this).width();
		});
		$('#nav_detail ul').width(width_ul_nav);
		
		
		
	
		$('.gallery-item').first().addClass('selected');
		$('#grande_partenaire_img').html('<img src="'+$('.gallery-item').first().find('a').attr('href')+'" alt="" />');
		$('.gallery-item').click(function(){
			$('.gallery-item').removeClass('selected');
			$(this).addClass('selected');
			$('#grande_partenaire_img').html('<img src="'+$(this).find('a').attr('href')+'" alt="" />');
			return false;
		});

	});
</script>

<?php include('menu_groupe.php'); ?>

<?php if (have_posts()) : while (have_posts()) : the_post();?>

<div id="container_content" class="page_groupe">
    <div class="content" id="content_partenaires">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP GROUP', 'piron'); ?> > <span><?php echo get_the_title($post->post_parent); ?></span> > <span class="current"><?php echo get_the_title(); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>

		<div id="menu_partenaires" class="menu_gauche">
			<img src="<?php echo get_template_directory_uri(); ?>/img/bg_historique.png"/>
			<?php $children = get_children(
					    array(
					        'post_parent' => $post->post_parent,
					        'orderby' => 'menu_order',
							'order'=>'ASC'
					    )
					);?>
        	<ul>
				<?php foreach ($children as $key=>$child) { ?>
            	<li <?php if ($key==get_the_ID()) echo 'class="selected"'; ?>><a href="<?php echo get_page_link($key); ?>"><?php echo strtoupper(get_the_title($key)); ?></a></li>
				<?php } ?>
            </ul>
        </div>
        
		<div id="partenaires">
        	<h1><?php echo strtoupper(get_the_title($post->post_parent)); ?> / <?php $value = get_post_meta(get_the_ID(), 'multiedit_nom_long', true); echo strtoupper(strip_tags($value, '<br><a><strong><b>')); ?></h1>
            
            <div id="grande_partenaire">
            	<div id="grande_partenaire_img"></div>
				<div class="logo"><?php echo get_post_meta(get_the_ID(), 'multiedit_logo', true); ?></div>
            </div>
            
            <div id="milieu_gauche_partenaire">
				<div id="liste_thumb">
					<?php the_content(); ?>
					<div class="clear"></div>
                </div>
				
                <div id="desc_partenaire">
                	<div class="chevron_rouge">&gt;</div>
                    <p>
					<?php echo get_post_meta(get_the_ID(), 'multiedit_images', true); ?>
                    <br/><br/>
                    <?php $value = get_post_meta(get_the_ID(), 'multiedit_web', true); echo strip_tags($value, '<br><a>'); ?>
                    </p>
                </div>
                
                <div id="infos_partenaire">
                	<div>
                    	<div class="chevron_rouge">&gt;</div>
                        <b><?php _e('Adresse', 'piron'); ?></b><br/>
                        <?php $value = get_post_meta(get_the_ID(), 'multiedit_adresse', true); echo strip_tags($value, '<br><a>'); ?>
                    </div>
                    <div>
                    	<div class="chevron_rouge">&gt;</div>
                        <b><?php _e('Usage', 'piron'); ?></b><br/>
                        <?php $value = get_post_meta(get_the_ID(), 'multiedit_usage', true); echo strip_tags($value, '<br><a>'); ?>
                    </div>
                    <div>
                    	<div class="chevron_rouge">&gt;</div>
                        <b><?php _e('Dur&eacute;e de construction', 'piron'); ?></b><br/>
                        <?php $value = get_post_meta(get_the_ID(), 'multiedit_duree', true); echo strip_tags($value, '<br><a>'); ?>
                    </div>
                    <div>
                    	<div class="chevron_rouge">&gt;</div>
                        <b><?php _e('Sp&eacute;cificit&eacute;s techniques', 'piron'); ?></b><br/>
                        <?php $value = get_post_meta(get_the_ID(), 'multiedit_specificites', true); echo strip_tags($value, '<br><a>'); ?>
 
                    </div>
                </div>
            </div>
            
            <div id="bas_partenaire">
            	<table>
                	<tr>
                    	<td><?php if ((get_post_meta(get_the_ID(), 'multiedit_contenu_1', true)) != ''){?>
                        	<div>
                        	<div class="chevron_rouge">&gt;</div>
                            <h5><?php $value = get_post_meta(get_the_ID(), 'multiedit_titre_1', true); echo strip_tags($value, '<br><a><strong><b>'); ?></h5>
                            <?php $value = get_post_meta(get_the_ID(), 'multiedit_contenu_1', true); echo strip_tags($value, '<br><a><strong><b>'); ?>
                            </div>
							<?php } ?>
                        </td>
                        <td class="separator">
                        </td>
                        <td><?php if ((get_post_meta(get_the_ID(), 'multiedit_contenu_2', true)) != ''){?>
                        	<div>
                        	<div class="chevron_rouge">&gt;</div>
                            <h5><?php $value = get_post_meta(get_the_ID(), 'multiedit_titre_2', true); echo strip_tags($value, '<br><a><strong><b>'); ?></h5>
                            <?php $value = get_post_meta(get_the_ID(), 'multiedit_contenu_2', true); echo strip_tags($value, '<br><a><strong><b>'); ?>
                            </div>
							<?php } ?>
                        </td>
                        <td class="separator">
                        </td>
                        <td><?php if ((get_post_meta(get_the_ID(), 'multiedit_contenu_3', true)) != ''){?>
                        	<div>
                        	<div class="chevron_rouge">&gt;</div>
                            <h5><?php $value = get_post_meta(get_the_ID(), 'multiedit_titre_3', true); echo strip_tags($value, '<br><a><strong><b>'); ?></h5>
                            <?php $value = get_post_meta(get_the_ID(), 'multiedit_contenu_3', true); echo strip_tags($value, '<br><a><strong><b>'); ?>
                            </div>
							<?php } ?>
                        </td>
                    </tr>
                    <tr>
                    	<td>
                        	
                        </td>
                        <td class="separator">
                        </td>
                        <td><?php if ((get_post_meta(get_the_ID(), 'multiedit_contenu_4', true)) != ''){?>
                        	<div>
                        	<div class="chevron_rouge">&gt;</div>
                            <h5><?php $value = get_post_meta(get_the_ID(), 'multiedit_titre_4', true); echo strip_tags($value, '<br><a><strong><b>'); ?></h5>
                            <?php $value = get_post_meta(get_the_ID(), 'multiedit_contenu_4', true); echo strip_tags($value, '<br><a><strong><b>'); ?>
                            </div>
							<?php } ?>
                        </td>
                        <td class="separator">
                        </td>
                        <td><?php if ((get_post_meta(get_the_ID(), 'multiedit_contenu_5', true)) != ''){?>
                        	<div>
                        	<div class="chevron_rouge">&gt;</div>
                            <h5><?php $value = get_post_meta(get_the_ID(), 'multiedit_titre_5', true); echo strip_tags($value, '<br><a><strong><b>'); ?></h5>
                            <?php $value = get_post_meta(get_the_ID(), 'multiedit_contenu_5', true); echo strip_tags($value, '<br><a><strong><b>'); ?>
                            </div>
							<?php } ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        
        <div class="spacer"></div> 
    	
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>