<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 *
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet (lowercase and without spaces)
	$themename = get_option( 'stylesheet' );
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option('optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option('optionsframework', $optionsframework_settings);

	// echo $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 */

function optionsframework_options() {



	$options = array();

	$options[] = array(
		'name' => 'Carrousel home',
		'type' => 'heading');
		
	$options[] = array(
		'name' => 'Lien image 1 fr',
		'desc' => '',
		'id' => 'lien_1_fr',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 1 en',
		'desc' => '',
		'id' => 'lien_1_en',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 1 de',
		'desc' => '',
		'id' => 'lien_1_de',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => 'Image 1 fr',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_1_fr',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 1 en',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_1_en',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 1 de',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_1_de',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Lien image 2 fr',
		'desc' => '',
		'id' => 'lien_2_fr',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 2 en',
		'desc' => '',
		'id' => 'lien_2_en',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 2 de',
		'desc' => '',
		'id' => 'lien_2_de',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => 'Image 2 fr',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_2_fr',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 2 en',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_2_en',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 2 de',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_2_de',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Lien image 3 fr',
		'desc' => '',
		'id' => 'lien_3_fr',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 3 en',
		'desc' => '',
		'id' => 'lien_3_en',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 3 de',
		'desc' => '',
		'id' => 'lien_3_de',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => 'Image 3 fr',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_3_fr',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 3 en',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_3_en',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 3 de',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_3_de',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Lien image 4 fr',
		'desc' => '',
		'id' => 'lien_4_fr',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 4 en',
		'desc' => '',
		'id' => 'lien_4_en',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 4 de',
		'desc' => '',
		'id' => 'lien_4_de',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => 'Image 4 fr',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_4_fr',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 4 en',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_4_en',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 4 de',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_4_de',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Lien image 5 fr',
		'desc' => '',
		'id' => 'lien_5_fr',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 5 en',
		'desc' => '',
		'id' => 'lien_5_en',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => 'Lien image 5 de',
		'desc' => '',
		'id' => 'lien_5_de',
		'std' => '#',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => 'Image 5 fr',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_5_fr',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 5 en',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_5_en',
		'type' => 'upload');
		
	$options[] = array(
		'name' => 'Image 5 de',
		'desc' => '',
		'std' => '#',
		'id' => 'slider_5_de',
		'type' => 'upload');

	return $options;
}