<?php
/*
Template Name: Explications
MultiEdit:image,savoirfaire
*/
?>
<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post();?>

<?php get_sidebar(); ?>

<script>
	$(document).ready(function(){
		
		
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');

		$('#groupe_groupe').addClass('selected');	
	

	});
</script>

<?php include('menu_groupe.php'); ?>



<div id="container_content" class="page_groupe">
    <div class="content content_groupe_groupe" id="content_explications">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP GROUP', 'piron'); ?> > <?php _e('Le groupe', 'piron'); ?> > <span class="current"><?php echo get_the_title(); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>

		<div id="menu_historique" class="menu_gauche">
			<img src="<?php echo get_template_directory_uri(); ?>/img/bg_historique.png"/>
        	<ul>
			<?php 
									if (get_locale()=='fr_FR') $page_id = 98;
									else if (get_locale()=='en_US') $page_id = 215;
									else if (get_locale()=='de_DE') $page_id = 384;?>
            	<li><a href="<?php echo get_page_link($page_id); ?>"><?php echo strtoupper(get_the_title($page_id)); ?></a></li>
				<?php 
									if (get_locale()=='fr_FR') $page_id = 116;
									else if (get_locale()=='en_US') $page_id = 211;
									else if (get_locale()=='de_DE') $page_id = 381;?>
                <li class="selected"><a href="<?php echo get_page_link($page_id); ?>"><?php echo strtoupper(get_the_title($page_id)); ?></a></li>
                <?php 
									if (get_locale()=='fr_FR') $page_id = 1115;
									else if (get_locale()=='en_US') $page_id = 1127;
									else if (get_locale()=='de_DE') $page_id = 1123;?>
                <li><a href="<?php echo get_page_link($page_id); ?>"><?php echo strtoupper(get_the_title($page_id)); ?></a></li>
                <?php 
									if (get_locale()=='fr_FR') $page_id = 1130;
									else if (get_locale()=='en_US') $page_id = 1140;
									else if (get_locale()=='de_DE') $page_id = 1137;?>
                <li><a href="<?php echo get_page_link($page_id); ?>"><?php echo strtoupper(get_the_title($page_id)); ?></a></li>
            </ul>
        </div>
        
        <div id="explications">
        	<h1><?php _e('LE GROUPE', 'piron'); ?> / <?php echo strtoupper(get_the_title()); ?></h1>
            
            <div id="image_explications">
            	<?php $value = get_post_meta(get_the_ID(), 'multiedit_image', true); echo strip_tags($value, '<br><img>'); ?>
            </div>
            
            <div id="savoir_faire">
            	<div>
					<?php
					if (get_locale()=='fr_FR') $lang_suffix = 'fr';
					else if (get_locale()=='en_US') $lang_suffix = 'en';
					else if (get_locale()=='de_DE') $lang_suffix = 'de';
					?>
                	<img src="<?php echo get_template_directory_uri(); ?>/img/explications_savoirfaire_<?php echo $lang_suffix; ?>.png" alt="" />
                </div>
                <div class="chevron_rouge">
                	>
                </div>
                <div id="savoirfaire_texte">
                	<?php $value = get_post_meta(get_the_ID(), 'multiedit_savoirfaire', true); echo strip_tags($value, '<br><img><span>'); ?>
                </div>
            </div>
            <div class="clear"></div>
            <div id="bas">
            	<span class="titre"><?php _e('LE GROUPE THOMAS <span class="rouge">&amp;</span> PIRON, C\'EST :', 'piron'); ?></span>
            	<br/><br/>
                <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/img/logo_lux.png" alt="thomas & piron luxembourg" /></a>
                <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/img/logo_belgique.png" alt="thomas & piron belgique" /></a>
                <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/img/logo_groupe.png" alt="thomas & piron groupe" /></a><br /><br/>
				<?php the_content(); ?>

            
            </div>
           <div class="spacer"></div> 
    	</div>
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>