<?php
/*
Template Name: Contacts
MultiEdit:horaires,latitude,longitude,nom_adresse,mail,adresse
*/
?>

<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post();?>

<?php get_sidebar(); ?>
            
<script>
	$(document).ready(function(){
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$('#groupe_contacts').addClass('selected');
		
		$('#formulaire_perso input').each(function(){
			$(this).attr('src', $(this).attr('value'));
		});
		$('#formulaire_perso textarea').each(function(){
			$(this).attr('src', $(this).html());
		});
		
		var position = new google.maps.LatLng(
		<?php $value = get_post_meta(get_the_ID(), 'multiedit_latitude', true); echo strip_tags($value, '<br>'); ?>, 
		<?php $value = get_post_meta(get_the_ID(), 'multiedit_longitude', true); echo strip_tags($value, '<br>'); ?>)
	
	
		var myOptions = {
		  center: position,
		  zoom: 8,
		  mapTypeId: google.maps.MapTypeId.ROADMAP,
		  disableDefaultUI: true,
		  panControl: true,
		  zoomControl: true,
		  overviewMapControl: true
		};
		map = new google.maps.Map(document.getElementById('gmap_content'),
			myOptions);	
		map.setZoom(15);
		map.panTo(position);
		
		marker = new google.maps.Marker({
			position: position,
			title:"TP",
			icon:"<?php echo get_template_directory_uri(); ?>/img/marker_gmap.png",
			draggable: false,
			visible: true
		});
		marker.setMap(map);
		
	});
</script>

<?php include('menu_groupe.php'); ?>



<div id="container_content" class="page_groupe">
    <div class="content" id="content_contact">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <a href="#"><?php _e('TP GROUP', 'piron'); ?></a> > <span class="current"><?php echo get_the_title(); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron');?></div>

		<div id="contact">
        	<h1><?php echo strtoupper(get_the_title()); ?></h1>
            <div id="container_gmap">
                <div id="gmap_content">
                </div>
            </div>
            
            <div id="encart_contacts">
            	<div id="chevron">
            		<span class="chevron_rouge">&gt;</span>
                </div>
                <div id="content_encart">
                	<span class="titre"><?php $value = get_post_meta(get_the_ID(), 'multiedit_nom_adresse', true); echo strip_tags($value, '<br>'); ?></span><br/>
                    <?php $value = get_post_meta(get_the_ID(), 'multiedit_adresse', true); echo strip_tags($value, '<br>'); ?><br/>
					<?php $value = get_post_meta(get_the_ID(), 'multiedit_mail', true);?>
                    <span class="rouge"><a href="mailto:<?php echo strip_tags($value);?>"> <?php echo strip_tags($value, '<br>'); ?></a></span><br/><br/>
                    <span class="italic">
                        <?php $value = get_post_meta(get_the_ID(), 'multiedit_horaires', true); echo strip_tags($value, '<br>'); ?>
                    </span>
                </div>
                
                <div id="formulaire_perso">
                    <?php the_content(); ?>
                </div>
             </div>
                    
                </div>
            </div>
        </div>
        <div class="spacer"></div> 
    	
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>