<?php
/*
Template Name: Appartement détail

*/

if ($_GET['id'] == '') {
	if (get_locale()=='fr_FR') $page_id = 1080;
		else if (get_locale()=='en_US') $page_id = 1083;
		else if (get_locale()=='de_DE') $page_id = 1082;
	header('Location: '.get_page_link($page_id));
}
?>

<?php get_header(); ?>
<?php get_sidebar(); ?>

<?php
$biens = $wpdb->get_results("SELECT id_bien, titre, id_parent, nom_projet, etat, 
nature, sous_nature, 
adresse, adresse_bis, adresse_num, code_postal, ville, pays FROM biens", ARRAY_A);

$maisons_projet = array();
$apparts_projet = array();

foreach ($biens as $bien){
	if (strpos(strtolower($bien['nature']), 'maison') !== false || strpos(strtolower($bien['nature']), 'terrain') !== false ){
		if ($bien['id_parent'] == 0){
			if (!array_key_exists($bien['id_bien'], $maisons_projet)){
				$maisons_projet[$bien['id_bien']] = array();
			}
			array_push($maisons_projet[$bien['id_bien']], $bien);
		}
		else {
			if (!array_key_exists($bien['id_parent'], $maisons_projet)){
				$maisons_projet[$bien['id_parent']] = array();
			}
			array_push($maisons_projet[$bien['id_parent']], $bien);
		}
	}
	else if (strpos(strtolower($bien['nature']), 'appartement') !== false){
			
		if ($bien['id_parent'] == 0){
			if (!array_key_exists($bien['id_bien'], $apparts_projet)){
				$apparts_projet[$bien['id_bien']] = array();
			}
			array_push($apparts_projet[$bien['id_bien']], $bien);
		}
		else {
			if (!array_key_exists($bien['id_parent'], $apparts_projet)){
				$apparts_projet[$bien['id_parent']] = array();
			}
			array_push($apparts_projet[$bien['id_parent']], $bien);
		}
	}
}


while(key($apparts_projet) !== null && key($apparts_projet) != $_GET['id']) { next($apparts_projet); }
$prev_val  = prev($apparts_projet);
$prev_link = key($apparts_projet);
reset($apparts_projet);
while(key($apparts_projet) !== null && key($apparts_projet) != $_GET['id']) { next($apparts_projet); }
next($apparts_projet); 
$next_link = key($apparts_projet);
?>

<?php
$biens = $wpdb->get_results("SELECT id_bien, titre, id_parent, nom_projet, etat, titre, surface, surface_terrain, 
nature, sous_nature, indice_energetique, budget, lot, nombre_chambres, description_fr, description_de, description_en,
adresse, adresse_bis, adresse_num, code_postal, ville, pays FROM biens WHERE id_bien=".$_GET['id']." OR id_parent=".$_GET['id'], ARRAY_A);

$moyenne_terrain = 0;
$moyenne_surface = 0;
$prix_mini=0;



$query = "SELECT id_bien, nom_photo FROM photos WHERE ";
$cpt=0;
foreach ($biens as $bien) {
	if ($cpt!=0) $query.=' OR ';
	$query.='id_bien='.$bien['id_bien'];
	$cpt++;
}
$photos = $wpdb->get_results($query, ARRAY_A);
$pourcent_vendu = 0;

if (sizeof($biens) > 1){
	$nb_biens = sizeof($biens) -1;
	foreach ($biens as $bien){
		if ($bien['id_parent']==0){
			$parent=$bien;
		}
		else {
			if ($bien['etat'] != 'L') {
				$pourcent_vendu++;
			}
			$moyenne_terrain+=$bien['surface_terrain'];
			$moyenne_surface+=$bien['surface'];
		}
		if ($bien['budget']<$prix_mini || $prix_mini=0){
			$prix_mini = $bien['budget'];
		}
	}
	$moyenne_terrain /= (sizeof($biens)-1);
	$moyenne_surface /= (sizeof($biens)-1);
	$pourcent_vendu = $pourcent_vendu / (sizeof($biens)-1) *100;
}
else {
	$parent = array_shift(array_values($biens));
	$moyenne_terrain = $parent['surface_terrain'];
	$moyenne_surface = $parent['surface'];
	$nb_biens = 1;
	$prix_mini = $parent['budget'];
	if ($parent['etat'] == 'L') $pourcent_vendu=0;
	else $pourcent_vendu=100;
}
?>

<script>
	$(document).ready(function(){

		
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$('#formulaire_perso input').each(function(){
			$(this).attr('src', $(this).attr('value'));
		});

			
		$('#menu_inter #immo_appartement').addClass('selected');
		
		var width_ul_nav = 0;
		$('#nav_detail ul>li').each(function(){
			width_ul_nav += $(this).width();
		});
		$('#nav_detail ul').width(width_ul_nav);
		
		$('.thumb').click(function(){
			$('.thumb').each(function(){
				$(this).removeClass("selected");
			});
			$(this).addClass("selected");
			$('#big_photo').attr('src', $(this).find('img').attr('src'));
		});
		$('#big_photo').attr('src', $('.thumb').first().find('img').attr('src'));
		
		$('#nom_bien_contact').html("<?php echo $parent['ville']; ?>");
		$('#immo_hidden').val("<?php echo $parent['ville']; ?>");
	});
</script>

<?php include('menu_immo.php'); ?>

<?php if (have_posts()) : while (have_posts()) : the_post();?>

<div id="container_content" class="page_immo">
    <div class="content content_immo_detail" id="content_appartements_detail">
    	<div class="spacer"></div>
		<?php 
		if (get_locale()=='fr_FR') $page_id = 1080;
		else if (get_locale()=='en_US') $page_id = 1083;
		else if (get_locale()=='de_DE') $page_id = 1082;?>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP IMMOBILIER', 'piron'); ?> > <a href="<?php echo get_page_link($page_id); ?>"><?php _e('Appartements', 'piron'); ?></a> > 
		<span class="current"><?php echo $parent['ville']; ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>
		<?php 
		if (get_locale()=='fr_FR') $appart_id = 1080;
									else if (get_locale()=='en_US') $appart_id = 1083;
									else if (get_locale()=='de_DE') $appart_id = 1082;?>
		<?php 
										if (get_locale()=='fr_FR') $page_id = 1088;
										else if (get_locale()=='en_US') $page_id = 1090;
										else if (get_locale()=='de_DE') $page_id = 1089;?>
    	<div id="nav_detail">
        	<ul>
            	<?php if ($prev_link != null){ ?><li><span class="rouge">&lt;</span> <a href="<?php echo get_page_link($detail_id).'?id='.$prev_link;?>"><?php _e('Projet pr&eacute;c&eacute;dent', 'piron'); ?></a></li><?php } ?>
                <li class="separator"></li>
                <li><b><a href="<?php echo get_page_link($appart_id); ?>"><?php _e('Retour &agrave; la liste appartements', 'piron'); ?></a></b></li>
                <li class="separator"></li>
                <?php if ($next_link != null){ ?><li><a href="<?php echo get_page_link($detail_id).'?id='.$next_link;?>"><?php _e('Projet suivant', 'piron'); ?></a> <span class="rouge">&gt;</span></li><?php } ?>
            </ul>
        </div>
        <div class="clear"></div>
        
        <table>
        	<tr>
            	<td id="detail_adresse"><span class="big"><?php echo strtoupper($parent['ville']); ?></span><br/><?php echo $parent['adresse']; ?></td>
                <td id="detail_imprimer" alt="imprimer" /><a href="javascript:window.print()"></a></td>
                <td id="detail_big" rowspan="3"><img src="" alt="photo" id="big_photo"/></td>
            </tr>
            <tr>
            	<td id="detail_carac" colspan="2">
                	<table>
                    	<tr>
                        	<td class="col1"><?php _e('NOM DE RESIDENCE :', 'piron'); ?></td>
                            <td class="col2"><?php echo $parent['titre']; ?></td>
                        </tr>
                        <tr>
                        	<td class="col1"><?php _e('NBRE DE LOTS :', 'piron'); ?></td>
                            <td class="col2"><?php echo $nb_biens;?> appartements</td>
                        </tr>
                        <tr>
                        	<td class="col1"><?php _e('SURFACE MOY. APPARTEMENTS :', 'piron');?></td>
                            <td class="col2"><?php echo $moyenne_surface; ?> m<sup>2</sup></td>
                        </tr>
                        <tr class="separator">
                        	<td colspan="2"></td>
                        </tr>
                        <tr >
                        	<td class="col1">-------</td>
                            <td class="col2"></td>
                        </tr>
                        <tr>
                        	<td class="col1"><?php _e('PERFORMANCE ENERGETIQUE :', 'piron'); ?><span class="vert"><b> *</b></span></td>
							
                            <td class="col2">
							
							<?php 
							if ($parent['indice_energetique'] !='0' && $parent['indice_energetique'] !='') { ?>
							<img src="<?php echo get_template_directory_uri(); ?>/img/energie_<?php echo $parent['indice_energetique']; ?>.png" alt="energie" />
							<?php } ?>
							</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
            	<td id="detail_prix" colspan="2"><span class="prix_1">&gt;</span> <span class="prix_2"><?php _e('Prix :', 'piron'); ?></span> <span class="prix_3"><?php _e('&agrave; partir de', 'piron');?> <?php echo number_format($prix_mini, 0, ',', '.'); ?> &euro; *</span></td>
            </tr>
            <tr>
            	<td id="detail_description" colspan="2"><span class="desc_1">&gt;</span> <span class="desc_2"><?php _e('Description', 'piron'); ?></span><br/>
<span class="desc_3"><?php 
if (get_locale()=='fr_FR') echo $parent['description_fr']; 
		else if (get_locale()=='en_US') echo $parent['description_en']; 
		else if (get_locale()=='de_DE') echo $parent['description_de']; 

?></span>
                </td>
                <td id="detail_thumbs">
					<?php $cpt=0;
					foreach ($photos as $photo){ 
					if ($cpt<5){?>
                	<div class="thumb button <?php if ($cpt==0) echo 'selected';?>">
                    	<img src="<?php echo site_url(); ?>/img/<?php echo $photo['nom_photo']; ?>" alt="thumb" />
                    </div>
					<?php } $cpt++;
					} ?>
                    
                </td>
            </tr>
        </table>
        <div class="clear"></div>
        
        <div id="liste_biens">
        	<span class="liste_1">&gt;</span> <span class="liste_2"><?php _e('Liste des biens', 'piron'); ?></span>
            <table>
            	<tr>
                	<th><?php _e('LOT', 'piron'); ?></th>
                    <th class="right"><?php _e('SURFACE', 'piron'); ?></th>
                    <th class="right"><?php _e('CHAMBRES', 'piron'); ?></th>
                    <th class="right"><?php _e('PRIX', 'piron'); ?></th>
                    <th><?php _e('PLANS', 'piron'); ?></th>
                    <th><?php _e('DISPONIBILITES', 'piron'); ?></th>
                </tr>
				<?php foreach ($biens as $bien){ 
				if ($bien != $parent || sizeof($biens)==1){ ?>
                <tr>
                	<td><a href="#"><?php echo $bien['lot']; ?></a></td>
                    <td class="right"><?php echo $bien['surface']; ?> m<sup>2</sup></td>
                    <td class="right"><?php echo $bien['nombre_chambres']; ?></td>
                    <td class="right"><?php echo number_format($bien['budget'], 0, ',', '.'); ?>&euro;</td>
                    <td><a href="#"><?php _e('Voir les plans', 'piron'); ?></a></td>
                    <td>
					<?php if ($bien['etat'] == 'L'){ ?>
					<span class="vert">Disponible</span>
					<?php } else { ?>
					<span class="rouge">Vendu</span>
					<?php } ?>
					</td>
                </tr>
				<?php }
				} ?>
            </table>
            <div id="pourcent_vendu">
            	<span class="big"><?php echo $pourcent_vendu; ?>%</span><br/>VENDUS
            </div>
        </div>
        
        <div id="contact">
        	<div id="gauche_contact">
                <span class="rouge">*</span> <span class="big"><?php _e('Nos prix comprennent toujours :', 'piron'); ?></span><br/>
                <?php _e('La TVA 3%  /  Les honoraires d\'architecte  /  Les frais de coordination  /  L\'&eacute;tude &eacute;nerg&eacute;tique du b&acirc;timent  /  La finition cl&eacute; sur porte', 'piron'); ?>
                <br/><br/>
                <span class="vert">*</span> <span class="big"><?php _e('Performance &eacute;nerg&eacute;tique', 'piron'); ?></span><br/>    
				<?php _e('Thomas &amp; Piron dispose de toutes les comp&eacute;tences pour optimiser la classe &eacute;nerg&eacute;tique de votre habitation. L\'obtention d\'une classe A,B ou C est syst&eacute;matiquement d&eacute;pendante de plusieurs facteurs dont l\'orientation du projet, le choix des mat&eacute;riaux, les caract&eacute;ristiques des techniques sp&eacute;ciales (chauffages, ventilation,...). C\'est pourquoi chaque projet personnalis&eacute; devra faire l\'objet d\'une &eacute;tude sp&eacute;cifique pour d&eacute;terminer la classe d\'&eacute;nergie.', 'piron'); ?>
   			</div>
            
            <div id="formulaire_perso">
				<?php
					$my_postid = get_the_ID();
					$content_post = get_post($my_postid);
					$content = $content_post->post_content;
					$content = apply_filters('the_content', $content);
					$content = str_replace(']]>', ']]&gt;', $content);
					echo $content;  
				?>
            </div>
            

        </div>
        <div class="spacer"></div>
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>