<?php
/*
Template Name: Liste Appartements

*/


?>

<?php get_header(); ?>
<?php get_sidebar(); ?>

<?php

$biens_est = array('AHN', 'ALTRIER','ALTWIES','BEAUFORT','BERBOURG','BERDORF','BERG','BEYREN','BIWER','BOLLENDORF-PONT','BOURGLINSTER','BOUS','BURMERANGE','CANACH','CHRISTNACH','CONSDORF','DAHLEIM','DILLINGEN',
'ECHTERNACH','EHNEN','ELVANGE','ERPELDANGE','FILSDORF','GIRST','GODBRANGE','GONDERANGE','GOSTINGEN','GRAULINSTER','GREIVELDANGE','GREVENMACHER','GRUNDHOF','HALLER','HUTTANGE','IMBRINGEN','JUNGLISTER',
'LENNINGEN','MACHTUM','MANTERNACH','MERTERT','MOERSDORF','MOMPACH','MONDORF LES BAINS','NIEDERDONVEN','OLINGEN','OSWEILER','REMERSCHEN','REMICH','RIPPIG','ROEDT','ROLLING','ROODT SUR SYRE','ROSPORT','SCHENGEN','STADTBREDIMUS',
'STEINHEIM','WALDBILLIG','WALDBREDIMUS','WASSERBILLIG','WECKER','WELFRANGE','WINTRANGE','WORMELDANGE','WORMELDANGE HAUT');

$biens_ouest = array('BASCHARAGE','BECKERICH','BETTANGE-SUR-MESS','BIGONVILLE','BILSDORF','BRIDEL','CALMUS','CAPELLEN','CLEMENCY','COLPACH-BAS','COLPACH-HAUT','DAHLEM','DIPPACH','EISCHEN','ELL','EVERLANGE','FINGIG',
'FOLSCHETTE','GARNICH','GOEBLANGE','GOETZANGE','GREISCH','GROSBOUS','HAGEN','HAUTCHARAGE','HOBSCHEID','HOLZEM','HOVELANGE','KAHLER','KEHLEN','KEISPELT','KLEINBETTINGEN','KOERICH','KOETSCHETTE','LEVELANGE','LINGER',
'LINGER','MAMER','MEISPELT','MICHELBOUCH','NAGEM','NIEDERPALLEN','NOERDANGE','NOSPELT','OLM','OSPERN','PETIT-NOBRESSART','PRATZ','RAMBROUCH','REDANGE-SUR-ATTERT','REICHLANGE','ROODT/REDANGE','ROODT/SEPTFONTAINES','SAEUL',
'SCHOUWEILER','SCHWEBACH','SCHWEICH','SEPTFONTAINES','SPRINKANGE','STEINFORT','USELDANGE','VICHTEN','WAHL','WOLWELANGE');

$biens_nord = array('ASSELBORN','BASCHLEIDEN','BASTENDORF','BAVIGNE','BETTBORN','BETTEL','BETTENDORF','BIGELBACH','BIWISCH','BOEVANGE','BOULAIDE','BOURSCHEID','BOXHORN','BRANDENBOURG','BURDEN',
'CLERVAUX','CONSTHUM','DAHL','DIEKIRCH','DIRBACH','DONCOLS','DRAUFFELT','ENSCHERANGE','EPPELDORF','ERMSDORF','ERPELDANGE','ESCHDORF','ESCHWEILER','ESELBORN','ETTELBRUCK','FEULEN','FISCHBACH','FOUHREN',
'GILSDORF','GOESDORF','GRALINGEN','HAMIVILLE','HARLANGE','HEIDERSCHEID','HEIDERSCHEIDERGRUND','HEINERSCHEID','HOBSCHEID','HOESDORF','HOLZTHUM','HOSINGEN','HULDANGE','INGELDORF','ISENBORN','KAUTENBACH','KNAPHOSCHEID','LELLINGEN',
'LIELER','MARNACH','MEDERNACH','MERSCHEID','MERTZIG','MICHELAU','MOESTROFF','MUNSHAUSEN','NACHTMANDERSCHEID','NEIDHAUSEN','NEUNHAUSEN','NIEDERFEULEN','NIEDERWAMPACH','NOCHER','OBEREISENBACH','OBERFEULEN','OBERWAMPACH','PINTSCH',
'REISDORF','REULER','ROULLINGEN','SCHIEREN','SELSCHEID','SIEBENALER','STOLZEMBOURG','SURRE','TANDEL','TROINE','TROIS VIERGES','UNTEREISENBACH','VIANDEN','WAHLHAUSEN','WARKEN','WEIDINGEN','WEILER','WEISWAMPACH','WEMPERHARDT',
'WILTZ','WILWERWILTZ','WINCRANGE');

$biens_sud = array('ASPELT ','BELVAUX','BERCHEM','BERGEM','BETTEMBOURG','BIVANGE','CRAUTHEM','DUDELANGE','EHLANGE/MESS','ESCH/ALZETTE','FENNANGE','FOETZ','FRISANGE','HELLANGE','KAYL',
'LAMADELAINE','LEUDELANGE','MONDERCANGE','NIEDERKORN','NOERTZANGE','OBERKORN','PETANGE','PISSANGE','PONTPIERRE','RECKANGE/MESS','RODANGE','ROESER','RUMELANGE','SANEM','SCHIFFLANGE','SOLEUVRE','TETANGE');

$biens_centre = array('ALZINGEN','ANGELSBERG','BERELDANGE','BERINGEN','BERSCHBACH','BERTRANGE','BISSEN','BOFFERDANGE','BROUCH','BUSCHDORF','COLMAR BERG','CONTERN','CRUCHTEN',
'EICH','ERNSTER','FENTANGE','FINSTERTHAL','FISCHBACH','GARE','GASPERICH','GREVENKNAPP','GRUND','HAMM','HASSEL','HEFFINGEN','HEISDORF','HELMDANGE','HESPERANGE','HOLLERICH','HOWALD',
'HUNSDORF','ITZIG','KALCHESBRECK','KIRCHBERG','KOHLENBERG','LAROCHETTE','LIMPERTSBERG','LINTGEN','LORENTZWEILER','LUX','MERL','MERSCH','MOUTFORT','MUEHLENBACH','MUNSBACH','NEUDORF','NIEDERANVEN',
'OBERANVEN','OETRANGE','PFAFFENTHAL','PULVERMUEHLE','RAMELDANGE','RECKANGE/MERSCH','RECKENTHAL','ROLLINGEN/MERSCH','ROLLINGERGRUND','SANDWEILER','SCHOOS','SCHRASSIG','SCHRONDWEILER','SCHUTTRANGE','SENNINGEN','SENNINGERBERG','STEINSEL',
'STRASSEN','SYREN','TUNTANGE','WALFERDANGE','WEILER LA TOUR','WEIMERSHOF','WEIMERSKIRCH');

if (isset($_POST['form_posted'])){
	$query = "SELECT id_bien, titre, id_parent, nom_projet, etat, 
	nature, sous_nature, 
	adresse, adresse_bis, adresse_num, code_postal, ville, pays FROM biens WHERE 1";

	if (isset($_POST['est']) || isset($_POST['ouest']) || isset($_POST['nord']) || isset($_POST['sud']) || isset($_POST['centre'])){
		$query.=' AND (';
		if (isset($_POST['est'])){
			foreach ($biens_est as $point){
				if ($cpt!=0) $query.=' OR';
				$query.= ' ville LIKE "'.$point.'"';
				$cpt++;
			}
		}
		if (isset($_POST['ouest'])){
			foreach ($biens_ouest as $point){
				if ($cpt!=0) $query.=' OR';
				$query.= ' ville LIKE "'.$point.'"';
				$cpt++;
			}
		}
		if (isset($_POST['nord'])){
			foreach ($biens_nord as $point){
				if ($cpt!=0) $query.=' OR';
				$query.= ' ville LIKE "'.$point.'"';
				$cpt++;
			}
		}
		if (isset($_POST['sud'])){
			foreach ($biens_sud as $point){
				if ($cpt!=0) $query.=' OR';
				$query.= ' ville LIKE "'.$point.'"';
				$cpt++;
			}
		}
		if (isset($_POST['centre'])){
			foreach ($biens_centre as $point){
				if ($cpt!=0) $query.=' OR';
				$query.= ' ville LIKE "'.$point.'"';
				$cpt++;
			}
		}
		$query.=')';
	}
	
	if (isset($_POST['chambre_1']) || isset($_POST['chambre_2']) || isset($_POST['chambre_3']) || isset($_POST['chambre_4'])){
		$cpt=0;
		$query.=' AND (';
		if (isset($_POST['chambre_1'])){
			if ($cpt!=0) $query.=' OR';
			$query.= ' nombre_chambres = 1';
			$cpt++;
		}
		if (isset($_POST['chambre_2'])){
			if ($cpt!=0) $query.=' OR';
			$query.= ' nombre_chambres = 2';
			$cpt++;
		}
		if (isset($_POST['chambre_3'])){
			if ($cpt!=0) $query.=' OR';
			$query.= ' nombre_chambres = 3';
			$cpt++;
		}
		if (isset($_POST['chambre_4'])){
			if ($cpt!=0) $query.=' OR';
			$query.= ' nombre_chambres >= 4';
			$cpt++;
		}
		$query.=')';
	}

	if ($_POST['form_prix_1']!=''){
		$query.= ' AND budget>='.$_POST['form_prix_1'];
	}
	if ($_POST['form_prix_2']!=''){
		$query.= ' AND budget<='.$_POST['form_prix_2'];
	}
	if ($_POST['form_surface_1']!=''){
		$query.= ' AND surface>='.$_POST['form_surface_1'];
	}
	if ($_POST['form_surface_2']!=''){
		$query.= ' AND surface<='.$_POST['form_surface_2'];
	}
	
	$biens = $wpdb->get_results($query, ARRAY_A);
}

else {
	$biens = $wpdb->get_results("SELECT id_bien, titre, id_parent, nom_projet, etat, 
	nature, sous_nature, 
	adresse, adresse_bis, adresse_num, code_postal, ville, pays FROM biens", ARRAY_A);
}

$photos = $wpdb->get_results("SELECT id_bien, nom_photo FROM photos", ARRAY_A);

$maisons_projet = array();
$apparts_projet = array();

foreach ($biens as $bien){
	if (strpos(strtolower($bien['nature']), 'maison') !== false || strpos(strtolower($bien['nature']), 'terrain') !== false ){
		if ($bien['id_parent'] == 0){
			if (!array_key_exists($bien['id_bien'], $maisons_projet)){
				$maisons_projet[$bien['id_bien']] = array();
			}
			array_push($maisons_projet[$bien['id_bien']], $bien);
		}
		else {
			if (!array_key_exists($bien['id_parent'], $maisons_projet)){
				$maisons_projet[$bien['id_parent']] = array();
			}
			array_push($maisons_projet[$bien['id_parent']], $bien);
		}
	}
	else if (strpos(strtolower($bien['nature']), 'appartement') !== false){
			
		if ($bien['id_parent'] == 0){
			if (!array_key_exists($bien['id_bien'], $apparts_projet)){
				$apparts_projet[$bien['id_bien']] = array();
			}
			array_push($apparts_projet[$bien['id_bien']], $bien);
		}
		else {
			if (!array_key_exists($bien['id_parent'], $apparts_projet)){
				$apparts_projet[$bien['id_parent']] = array();
			}
			array_push($apparts_projet[$bien['id_parent']], $bien);
		}
	}
}
?>

<script>
	$(document).ready(function(){
		
		
		$('#container_menu #menu').css('-moz-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('-webkit-box-shadow', '0px 0px 0px #424242');
		$('#container_menu #menu').css('box-shadow', '0px 0px 0px #424242');
		
		$( "#slider-surface" ).slider({
			  range: true,
			  min: 0,
			  max: 500,
			  values: [ <?php if ($_POST['form_surface_1']!='') echo $_POST['form_surface_1']; else echo '0'; ?>, <?php if ($_POST['form_surface_2']!='') echo $_POST['form_surface_2']; else echo '500'; ?> ],
			  slide: function( event, ui ) {
				$( "#surface_1" ).html( $( "#slider-surface" ).slider( "values", 0 ));
				$( "#surface_2" ).html( $( "#slider-surface" ).slider( "values", 1 ));
				$('#form_surface_1').val($( "#slider-surface" ).slider( "values", 0 ));
				$('#form_surface_2').val($( "#slider-surface" ).slider( "values", 1 ));
			  }
			});
			$( "#surface_1" ).html( $( "#slider-surface" ).slider( "values", 0 ));
			$( "#surface_2" ).html( $( "#slider-surface" ).slider( "values", 1 ));
			
		$( "#slider-prix" ).slider({
			  range: true,
			  min: 0,
			  max: 1500000,
			  step:1000,
			  values: [ <?php if ($_POST['form_prix_1']!='') echo $_POST['form_prix_1']; else echo '0'; ?>, <?php if ($_POST['form_prix_2']!='') echo $_POST['form_prix_2']; else echo '1500000'; ?> ],
			  slide: function( event, ui ) {
				$( "#prix_1" ).html( CommaFormatted($( "#slider-prix" ).slider( "values", 0 )));
				$( "#prix_2" ).html( CommaFormatted($( "#slider-prix" ).slider( "values", 1 )));
				$('#form_prix_1').val($( "#slider-prix" ).slider( "values", 0 ));
				$('#form_prix_2').val($( "#slider-prix" ).slider( "values", 1 ));
			  }
			});
			$( "#prix_1" ).html( CommaFormatted($( "#slider-prix" ).slider( "values", 0 )));
			$( "#prix_2" ).html( CommaFormatted($( "#slider-prix" ).slider( "values", 1 )));
		
		$('#menu_inter #immo_appartement').addClass('selected');
			
		$('#form_prix_1').val($( "#slider-prix" ).slider( "values", 0 ));
		$('#form_prix_2').val($( "#slider-prix" ).slider( "values", 1 ));
		$('#form_surface_1').val($( "#slider-surface" ).slider( "values", 0 ));
		$('#form_surface_2').val($( "#slider-surface" ).slider( "values", 1 ));

	});
</script>

<?php include('menu_immo.php'); ?>

<?php if (have_posts()) : while (have_posts()) : the_post();?>

<div id="container_content" class="page_immo">
    <div class="content content_immo_liste" id="content_appartements">
    	<div class="spacer"></div>
        <div id="ariane"><a href="#"><?php _e('Accueil', 'piron'); ?></a> > <?php _e('TP IMMOBILIER', 'piron'); ?> > <span class="current"><?php _e('Appartements', 'piron'); ?></span></div>
   		<div id="contactez-nous"><?php _e('Contactez-nous au 34 18 141', 'piron'); ?></div>

    
        <div id="recherche">
    
            
            <form id="form_recherche" method="post" action="<?php echo get_page_link(get_the_ID()); ?>">
    
                
                <div id="choix_caracs">
                    <div>
                        <table>
                            <tr>
                                <td colspan="2"><?php _e('REGION', 'piron'); ?></td>
                            </tr>
                            <tr>
                                <td>
                                    <input type="checkbox" id="nord" name="nord"/>
                                    <label for="nord"><?php _e('NORD', 'piron'); ?></label>
                                </td>
                                <td>
                                    <input type="checkbox" id="sud" name="sud"/>
                                    <label for="sud"><?php _e('SUD', 'piron'); ?></label>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <input type="checkbox" id="ouest" name="ouest"/>
                                    <label for="ouest"><?php _e('OUEST', 'piron'); ?></label>
                                </td>
                                <td>
                                    <input type="checkbox" id="est" name="est"/>
                                    <label for="est"><?php _e('EST', 'piron'); ?></label>
                                </td>
                            </tr>
							<tr>
                            	<td>
                                	<input type="checkbox" id="centre" name="centre"/>
                    				<label for="centre"><?php _e('CENTRE', 'piron');?></label>
                                </td>
                                <td>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="separator"></div>
                    <div>
                        <table>
                            <tr>
                                <td colspan="2"><?php _e('NBRE CHAMBRE(S)', 'piron'); ?></td>
                            </tr>
                            <tr>
                                <td>
                                    <input type="checkbox" id="chambre_1" name="chambre_1" <?php if (isset($_POST['chambre_1'])) echo 'checked="checked"'; ?>/>
                                    <label for="chambre_1">1</label>
                                </td>
                                <td>
                                    <input type="checkbox" id="chambre_2" name="chambre_2" <?php if (isset($_POST['chambre_2'])) echo 'checked="checked"'; ?>/>
                                    <label for="chambre_2">2</label>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <input type="checkbox" id="chambre_3" name="chambre_3" <?php if (isset($_POST['chambre_3'])) echo 'checked="checked"'; ?>/>
                                    <label for="chambre_3">3</label>
                                </td>
                                <td>
                                    <input type="checkbox" id="chambre_4" name="chambre_4" <?php if (isset($_POST['chambre_4'])) echo 'checked="checked"'; ?>/>
                                    <label for="chambre_4"><?php _e('4 et plus', 'piron'); ?></label>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="separator"></div>
                    <div>
                        <?php _e('SURFACE', 'piron'); ?><br/>
                        <div id="slider-surface"></div>
                        <span id="surface"><?php _e('DE <b><span id="surface_1"></span>m<sup>2</sup></b> &Agrave; <b><span id="surface_2"></span>m<sup>2</sup></b>', 'piron');?></span>
                    </div>
                    <div class="separator"></div>
                    <div>
                        <?php _e('PRIX', 'piron'); ?><br/>
                        <div id="slider-prix"></div>
                        <?php _e('<span id="prix">DE <b><span id="prix_1"></span> &euro;</b> &Agrave; <b><span id="prix_2"></span> &euro;</b></span>', 'piron');?>
                    </div>
                 </div>
                 <input type="hidden" name="form_prix_1" id="form_prix_1" value="" />
				 <input type="hidden" name="form_prix_2" id="form_prix_2" value="" />
				 <input type="hidden" name="form_surface_1" id="form_surface_1" value="" />
				 <input type="hidden" name="form_surface_2" id="form_surface_2" value="" />
                 <div class="clear"></div>
                <input type="hidden" name="form_posted" id="form_posted" value="ok" />
                <input type="image" src="<?php echo get_template_directory_uri(); ?>/img/search_immo.png" alt="rechercher"/>
            </form>
        </div>
        
        <div id="nb_projets"><span class="nb"><?php echo sizeof($apparts_projet); ?></span> <?php _e('projets', 'piron'); ?></div>
        
        <div id="liste_projets">
        	
            <?php $cpt_first=0;
			foreach ($apparts_projet as $key=>$projet_liste){ 
				$projet = array_shift(array_values($projet_liste));
			?>
				<div class="projet<?php if ($cpt_first<4) echo ' first_line';?>">
					<?php 
					if (get_locale()=='fr_FR') $page_id = 1088;
					else if (get_locale()=='en_US') $page_id = 1090;
					else if (get_locale()=='de_DE') $page_id = 1089;?>
                    <a class="container_image" href="<?php echo get_page_link($page_id);?>?id=<?php echo $key;?>"><img src="
					<?php 
					$changed = false;
					foreach ($photos as $photo){
						if (($photo['id_bien'] == $projet['id_bien'] || $photo['id_bien'] == $key) && !$changed){
							$photo_projet = $photo;
							$changed = true;
						}
					}
					echo site_url().'/img/'.$photo_projet['nom_photo']; ?>" alt="photo" class="img_bien" /></a>
                    <br/>
                    <div class="txt_projet">
                        <span class="titre_immo"><a href="<?php echo get_page_link($page_id);?>?id=<?php echo $key;?>"><?php echo strtoupper($projet['ville']); ?></a><br/></span>
                        <span class="desc_immo">
                            <?php if ($projet['adresse'] != '') echo $projet['adresse'].'<br/>';?>
                            <?php if ($projet['adresse_bis'] != '') echo $projet['adresse_bis'].'<br/>';?>
                            <?php _e('Total :', 'piron'); ?> <?php echo sizeof($projet_liste); ?> <?php _e('appartements', 'piron'); ?>
                        </span><br/>
						<?php $cpt=0;
						foreach ($projet_liste as $un_projet){
							if ($un_projet['etat'] == 'L'){
								$cpt++;
							}
						}?>
                        <span class="dispo_immo"><a href="<?php echo get_page_link($page_id);?>?id=<?php echo $key;?>">> <?php echo $cpt;?> <?php _e('appartements disponibles', 'piron'); ?>
						</a></span>
                    </div>
                    <div class="vendu">
					<?php 
					
					$pourcent = sizeof($projet_liste) - $cpt;
					$pourcent = $pourcent / sizeof($projet_liste) * 100;
					echo $pourcent;
					?>
					%<br/><span class="petit"><?php _e('VENDUS', 'piron'); ?></span></div>
                </div>
			<?php $cpt_first++;
			} ?> 
        <div class="clear"></div>
        <div style="width:1px; height:55px;"></div>
    </div>
</div>

<?php endwhile; endif; ?>

<?php get_footer(); ?>