<?php
@ini_set("memory_limit", "1024M");

list($version_php) = explode('.', phpversion());
$GLOBALS['version_php'] = $version_php;

$dossier_export="export/";

	// Class PCLZIP
	require_once('pclzip.lib.php');

/*********************************************************************/

	// Cre un document XML sachant que les cls de $t sont les differentes balises, et les valeurs
	//	ex : t = array('user/name' => 'David')
	//	On aura la balise root qui s'appelle $nom_root, un enfant user, un sous-enfant name, et la valeur 'David'
	function creationXML($nom_root, $t, $toString, $t_attributes = array(), $utf8 = false){

		if( $GLOBALS['version_php'] < 5 ){
			$xml = domxml_new_doc("1.0");
			$root = $xml->append_child($xml->create_element($nom_root));
			foreach( $t_attributes as $attr => $valeur )
				$root->set_attribute($attr, $valeur);
		}
		else{
			if( $utf8 )
				$xml = new DomDocument("1.0", 'UTF-8');
			else
				$xml = new DomDocument("1.0", 'ISO-8859-1');
			$root = $xml->appendChild($xml->createElement($nom_root));
			foreach( $t_attributes as $attr => $valeur )
				$root->setAttribute($attr, $valeur);
		}
		
		foreach($t as $chemin => $value){
			
			//	Noeud de travail
			$noeud = $root;
		
			$t_tmp = explode('/', $chemin);
			for($i=0; $i<count($t_tmp); $i++){
				
				//	Recuperation du nom du tag
				$ch = $t_tmp[$i];

				$stop = false; $j = 0;
				if( $GLOBALS['version_php'] < 5 ){
					$t_childs = $noeud->child_nodes();
					while( ($j < count($t_childs)) && !$stop ){		// On parcourt tous les enfants du noeud
						$stop = ($t_childs[$j]->tagname == $ch);	// stop = true si un enfant du noeud est ch
						$j++;
					}
				}
				else{
					$t_childs = $noeud->childNodes;
					while( ($j < $t_childs->length) && !$stop ){	// On parcourt tous les enfants du noeud
						$x = $t_childs->item($j);
						$stop = ($x->tagName == $ch);	// stop = true si un enfant du noeud est ch
						$j++;
					}
				}

				//	reSi on n'a pas trouve le tag, on le cree
				if( !$stop ){
					if( $GLOBALS['version_php'] < 5 )
						$noeud = $noeud->append_child($xml->create_element($ch));
					else
						$noeud = $noeud->appendChild($xml->createElement($ch));
				}
				else{
					if( $GLOBALS['version_php'] < 5 )
						$noeud = $t_childs[$j-1];
					else
						$noeud = $t_childs->item($j-1);
				}
			}


			//	Cration de la valeur du noeud
			if( $GLOBALS['version_php'] < '5' )
				$noeud->append_child($xml->create_text_node( utf8_encode($value) ));
			else
				$noeud->appendChild($xml->createTextNode( utf8_encode($value) ));
		}

		//	On retourne tout le document
		if( $toString ){
			
			if( $GLOBALS['version_php'] < 5 )
				return $xml->dump_mem();
			else
				return $xml->saveXML();
		}

		return $xml;
	}

	function urlsafe_b64decode($string) {
		
		if( $string != '' ){
			$data = str_replace(array('-','_'),array('+','/'),$string);
			/*$mod4 = strlen($data) % 4;
			if ($mod4) {
				$data .= substr('====', $mod4);
			}*/
			return base64_decode($data);
		}

		return '';
	}

	// Redimensionne l'image situe  $img_name en fonction de $L.
	// Une nouvelle image sera cre  $img_thumb. L'ancienne ne sera pas supprime.
	function createthumb($img_name, $img_thumb, $L = 400, $larg = 0) {

		$pic = imagecreatefromjpeg($img_name);
		$sizex = imagesx($pic) ;
		$sizey = imagesy($pic) ;
		$sX = $sizex;
		$sY = $sizey;

		if($L != -1){
			if($sX > $L ){
				$factor = $sX/$L;
				$sX = $sX/$factor;
				$sY = $sY/$factor;
			}
			if($sY > $L ){
				$factor = $sY/$L;
				$sX = $sX/$factor;
				$sY = $sY/$factor;
			}
		}
		else{
			if($sX > $larg ){
				$factor = $sizex/$larg;
				$sX = $sX/$factor;
				$sY = $sY/$factor;
			}
		}

		settype ($sX, "integer") ;
		settype ($sY, "integer") ;

		$out = imagecreatetruecolor( $sX, $sY) ;
		imagecopyresampled($out, $pic, 0, 0, 0, 0, $sX, $sY, $sizex, $sizey) ;
		imagejpeg($out, $img_thumb) ;
		imagedestroy($pic);
		imagedestroy($out);
	}

/*********************************************************************/

include('connexion.php');


/*********************************************************************/
	//On fait un test pour voir si la table DOCUMENT est cre
	/*$t_doc_exist = mysql_query("SELECT id_document FROM document LIMIT 1");
	if(!$t_doc_exist){
		$Query_doc = "CREATE TABLE `document` (".
				  "`id_document` int(11) NOT NULL auto_increment,".
				  "`idBien` int(11) NOT NULL default '0',".
				  "`fic_doc` varchar(255) NOT NULL default '',".
				  "`date` date NOT NULL default '0000-00-00',".
				  "`nom_doc` varchar(255) NOT NULL default '',".
				  "`en_ligne` binary(1) NOT NULL default '0',".
				  "PRIMARY KEY  (`id_document`)".
					")";
		@mysql_query($Query_doc);
	}*/

	//On fait un test pour voir si la table photos_e2p est cre
	$t_photoe2p_exist = mysql_query("SELECT idbien FROM photos LIMIT 1");
	if(!$t_photoe2p_exist){
		$Query_photoe2p = "CREATE TABLE `photos` (".
				  "`idphoto` int(11) NOT NULL auto_increment,".
				  "`idbien` int(11) NOT NULL,".
				  "`nomphoto` varchar(255) NOT NULL default '',".
				  "`publier` binary(1) NOT NULL default '0',".
				  "PRIMARY KEY  (`idphoto`)".
					")";
		@mysql_query($Query_photoe2p);
	}


/*********************************************************************/

//	Contient le fichier XML reu, si aucune erreur n'intervient
$xml = false;

//	Si diffrent de zro, c'est qu'il y a eu une erreur a l'execution d'une requete
$cpt = 0;


try{
		/************************************************************************************/
		/*		Reception des donnes par $_POST
		/************************************************************************************/
	$t_data = array();
	foreach( $_POST as $key => $value ){
		$t_data[$key] = urlsafe_b64decode($value);
	}
	
	$img_path = "../img";
	$doc_path = "../docs";
	
    $timestamp=time();
	$nom_zip = $timestamp.".zip";
	$fich = fopen($dossier_export.$nom_zip, 'w');
	fwrite($fich, $t_data['zip']);
	fclose($fich);
	$archive = new PclZip($dossier_export.$nom_zip);
	$donnees=$archive->extract();


	if($donnees!=0){

		@unlink($dossier_export.$nom_zip);
		$fichier=$donnees[0]["filename"];
		$fichier=substr($fichier,strrpos($fichier, "/")+1, strlen($fichier));
		$_GET['file']=urlencode($dossier_export.$fichier);
		include("lecteur_xml.php");
		//header("Location: lecteur_xml.php?file=".urlencode($dossier_export.$donnees['filename']));

	}else{
		echo "passe pas";
		
		$fich = fopen("log.txt", 'w');
		fwrite($fich, date("d/m/Y - h:m")." Erreur de fichier Zip"."\n");
		fclose($fich);

	}

}catch(Exception $e){
		echo "passe pas";

	$fich = fopen("log.txt", 'w');
	fwrite($fich, date("d/m/Y - h:m").$e->getMessage()."\n");
	fclose($fich);

}

@unlink($dossier_export.$nom_zip);
@unlink($dossier_export.$fichier);

?>